import math

def perimetro(a,b,c):
    """
    perimetro: num num num -> num
    calcula el perimetro de un triangulo de lados a, b, y c
    ejemplo: perimetro(2, 3, 2) devuelve 7
    """
    return a + b + c

#test
#print perimetro(2, 3, 2), "deberia ser 7"

def area(a, b, c):
    """
    area: num num num -> num
    calcula la area de un triangulo de lados a,b, y c
    ejemplo: area(2, 3, 2) devuelve 1.98...
    """
    semi = perimetro(a, b, c) / 2.0
    area = math.sqrt(semi * (semi - a) * (semi - b) * (semi - c))
    return area

#test
#print area(2, 3, 2), "deberia ser 1.98..."

def es_triangulo(a, b, c):
	"""
	es_triangulo: num num num -> bool
	devuelve True si los 3 lados forman un triangulo
	ejemplos:
	es_triangulo(1, 2, 3) devuelve False
	es_triangulo(1, 2, 2) devuelve True
	"""
	positivos = a > 0 and b > 0 and  c > 0
	tamanho = a + b > c and a + c > b and b + c > a
	return positivos and tamanho

assert es_triangulo(1, 2, 2)
assert es_triangulo(2, 2, 2)
assert not es_triangulo(1, 2, 3)
assert not es_triangulo(1, -2, 3)

def es_equilatero(a, b, c):
	"""
	es_equilatero: num num num -> bool
	devuelve True si los 3 lados forman un triangulo equilatero
	ejemplos:
	es_equilatero(1, 2, 3) devuelve False
	es_equilatero(2, 2, 2) devuelve True
	"""
	return a == b and a == c

assert not es_equilatero(1, 2, 3)
assert es_equilatero(2, 2, 2)

def es_isosceles(a, b, c):
	"""
	es_equilatero: num num num -> bool
	devuelve True si 3 lados forman un triangulo isosceles
	ejemplos:
	es_isosceles(1, 2, 3) devuelve False
	es_isosceles(2, 2, 2) devuelve True
	es_isosceles(3, 2, 2) devuelve True
	"""
	return  a == b or a == c or b == c

assert not es_isosceles(1, 2, 3)
assert es_isosceles(2, 2, 2)
assert es_isosceles(3, 2, 2)
assert es_isosceles(2, 3, 2)
assert es_isosceles(2, 2, 3)

def tipo(a, b, c):
	"""
	tipo: num num num -> string
	devuelve el tipo de triangulo describido por los 3 lados
	ejemplos:
	tipo_triangulo(1, 2, 3) devuelve "no triangulo"
	tipo_triangulo(1, 2, 2.5) devuelve "escaleno"
	tipo_triangulo(2, 3, 2) devuelve "isosceles"
	tipo_triangulo(2, 2, 2) devuelve "equilatero"
	"""
	if es_triangulo(a, b, c): 
		if es_equilatero(a, b, c):
			return "equilatero"
		elif es_isosceles(a,b, c):
			return "isosceles"
		else: return "escaleno"
	else: return "no triangulo"


assert tipo(1, 2, 3) == "no triangulo"
assert tipo(1, 2, 2.5) == "escaleno"
assert tipo(2, 3, 2) == "isosceles"
assert tipo(2, 2, 2) == "equilatero"
